* ssur3.prg
* v0.2.1
* 01 May 2012

* Program to forecast steady-state unemployment rate using 3-state model

calendar 1951 1 12
allocate 2100:12

declare integer FIRSTOBS LASTOBS ESTEND ESTBEG FCBEG FCEND FCLEN

open data input.csv
data(format=cdf, org=col) / E U N P EUR ENR UER UNR NER NUR HWI UIC
close data

** locate last observation for UR
set ur = U/(U+E)
inquire(series=ur) FIRSTOBS LASTOBS
set urdata = ur
set Udata = U
set Edata = E
set Ndata = N

*************************************************
*** PARAMETERS FOR ESTIMATION AND FORECASTING ***
*************************************************
compute NLAGS=3;                    * Number of lags in VAR
compute ESTEND=LASTOBS;             * End date for VAR estimation
compute ESTBEG=ESTEND-119;          * Start date for VAR estimation
compute FCLEN=24;                   * Forecast length
compute FCBEG=ESTEND+1;             * Starting date for UR forecast
compute FCEND=FCBEG+FCLEN;          * Last date for which forecasts are desired


***************************************
*** ESTIMATE AND SIMULATE VAR MODEL ***
***************************************
* logs of variables
set leur = log(eur{1})
set luer = log(uer{1})
set lenr = log(enr{1})
set lner = log(ner{1})
set lnur = log(nur{1})
set lunr = log(unr{1})
set lur = log(ur)
set luic = log(uic)
set lhwi = log(hwi)
* define VAR
system(model=ssur3)
variables leur luer lenr lner lnur lunr lur lhwi luic
lags 1 to NLAGS
det constant
end(system)
*
estimate(model=ssur3) ESTBEG ESTEND
forecast(model=ssur3,from=FCBEG,to=FCEND+1,results=fcasts)


****************************************
*** UR FORECAST WITH PREDICTED FLOWS ***
****************************************
* add in flows forecats
set eur FCBEG-1 FCEND = exp(fcasts(1){-1})
set uer FCBEG-1 FCEND = exp(fcasts(2){-1})
set enr FCBEG-1 FCEND = exp(fcasts(3){-1})
set ner FCBEG-1 FCEND = exp(fcasts(4){-1})
set nur FCBEG-1 FCEND = exp(fcasts(5){-1})
set unr FCBEG-1 FCEND = exp(fcasts(6){-1})
print(pict='*.#####') FCBEG-2 FCEND eur enr uer unr ner nur

* History
set s = enr*nur + ner*eur + nur*eur
set f = unr*ner + nur*uer + ner*uer
set g = eur*unr + uer*enr + unr*enr
*print(pict='*.#####') FCBEG-2 FCEND s f g

set P FCBEG FCEND = P{1}*(1.00939^(1./12.))

set U_ss = (P/(s+f+g))*s
set E_ss = (P/(s+f+g))*f
set N_ss = (P/(s+f+g))*g
set ssur  = U_ss/(E_ss+U_ss)
set sslfpr = (E_ss+U_ss)/(E_ss+U_ss+N_ss)
*print(pict='*.') FCBEG-2 FCEND U U_ss E E_ss N N_ss

* Compute eigenvalues of equation of motion and forecasts

declare rect A(3,3)
declare vector uenvec(3)
declare vector cexpvec(3)

do i=FCBEG-1,FCEND
  compute A(1,1)=-uer(i-1)-unr(i-1)
  compute A(1,2)=eur(i-1)
  compute A(1,3)=nur(i-1)
  compute A(2,1)=uer(i-1)
  compute A(2,2)=-eur(i-1)-enr(i-1)
  compute A(2,3)=ner(i-1)
  compute A(3,1)=unr(i-1)
  compute A(3,2)=enr(i-1)
  compute A(3,3)=-ner(i-1)-nur(i-1)
  *
  compute uenvec(1)=U(i-1)
  compute uenvec(2)=E(i-1)
  compute uenvec(3)=N(i-1)
  *
  eigen A eval evec
  *
  compute r1=eval(1)
  compute r2=eval(2)
  compute r3=eval(3)
  *
  compute cvector=inv(evec)*uenvec
  *
  compute cexpvec(1)=cvector(1,1)*exp(r1)
  compute cexpvec(2)=cvector(2,1)*exp(r2)
  compute cexpvec(3)=cvector(3,1)*exp(r3)
  *
  compute X=evec*cexpvec
  *
  set U i i = X(1,1)
  set E i i = X(2,1)
  set N i i = X(3,1)
end do iter

*print(pict='*.') FCBEG FCEND U E N

* calculate various rates
set E * LASTOBS = Edata
set U * LASTOBS = Udata
set N * LASTOBS = Ndata
set ur FCBEG FCEND = U/(E+U)
set lfpr = (E+U)/(E+U+N)
print(pict='*.#####') FCBEG FCEND ur lfpr


********************************
*** STORE SERIES TO CSV FILE ***
********************************
open(noappend) copy output.csv
copy(format=cdf,dates,org=columns) 1967:7 FCEND uer unr eur enr ner nur ur lfpr
close copy
